# Core v5.3.0
**Release Date:** January 17, 2025  
**Tags:** FEATURE, TRADING, ECOSYSTEM, BUG FIXES

## Fixed
- React key prop warnings in withdraw form currency selection caused by missing unique identifiers
- React Hooks order violation in WithdrawForm component due to conditional useTranslations calls
- Ecosystem token withdrawal methods displaying empty cards without proper method details
- Auto-selection of withdrawal methods removing user choice in method selection
- Empty fee badges displaying beside processing time when no fees are present
- Currency selection errors when API response format doesn't match expected structure
- Balance extraction failures from various API response formats in withdraw form
- Null value handling in withdraw form causing React warnings about null input values
- Back home button not working in spot trading page header due to nested interactive elements
- Maximum update depth exceeded error in markets panel caused by infinite re-render loop
- Custodial wallet creation showing duplicate backend path in production environment
- KYC application detail page returning Bad Gateway error due to missing authentication checks
- ScyllaDB connection attempts when ecosystem extension is not installed causing authentication errors
- Bad Gateway errors caused by invalid response handler method calls in API error handling
- KYC application page 502 errors on refresh due to missing client component directive
- 502 Bad Gateway errors on admin dynamic route page refreshes across multiple extensions
- Server-side rendering failures in admin pages importing client components without "use client"
- P2P trade detail, offer detail, and dispute detail admin pages causing 502 errors on refresh
- Ecommerce order detail admin page failing to load due to server-side rendering issues
- Staking pool detail admin page refresh errors from missing client component directive
- FAQ manage detail page and gateway edit page 502 errors from SSR configuration issues
- Affiliate referral detail and KYC level editor pages failing on browser refresh
- Harsh button colors in KYC application review sidebar causing eye strain
- Inconsistent dark mode styling across KYC application detail page components
- Missing dark mode support in verification tab status indicators and progress bars
- User profile tab components lacking proper dark mode color variants
- Application details tab using gray color palette instead of zinc design system colors
- Light backgrounds in AI analysis sections not adapting to dark theme
- Status badges and verification cards missing dark mode styling
- KYC application details drawer taking up insufficient screen space on desktop and mobile
- Type field badges positioned incorrectly on small screens in KYC application forms
- Content being cut off and not scrollable in KYC application details drawer on mobile devices
- Application form data tabs not responsive on small screens causing poor mobile experience
- Support ticket detail page causing 502 Bad Gateway errors when accessed directly or on refresh

## Enhanced
- Trading markets system with ecosystem market prioritization over spot markets
- Market deduplication logic ensuring ecosystem markets take precedence when same symbol exists in both
- Comprehensive API response handling for multiple currency formats in withdraw form
- Withdrawal method display with proper titles, fees, processing times, and instructions
- Currency selection interface with support for ecosystem tokens and traditional currencies
- Market service with intelligent caching and real-time ecosystem market integration
- Withdraw form validation with enhanced error handling and user feedback
- Token icon display in withdrawal methods with fallback mechanisms
- Trading header navigation with programmatic routing for better reliability
- Markets panel performance with optimized useEffect dependencies and state updates
- File path resolution for ecosystem wallets with multiple environment fallbacks
- KYC application page with proper authentication guards and error handling
- System health checks with conditional service availability based on installed extensions
- API error handling with proper response methods for validation and server errors
- KYC application page routing with proper client component configuration
- Admin dynamic route pages with proper Next.js App Router client component directives
- Extension admin detail pages with correct SSR/CSR configuration for browser compatibility
- Dynamic route handling across P2P, Ecommerce, Staking, FAQ, and other admin interfaces
- KYC application review buttons with softer, eye-friendly colors and proper contrast ratios
- Comprehensive dark mode styling across all KYC application page components
- Verification tab with complete dark mode support for all status types and progress indicators
- User profile tab with dark mode variants for contact information and account security cards
- Application details tab with zinc color palette compliance and proper dark theme backgrounds
- AI analysis sections with dark mode backgrounds and improved readability
- Status badges and verification cards with consistent dark mode styling patterns
- KYC application details drawer with 90% screen width for better content viewing and review experience
- Mobile layout optimization for KYC application details with proper scrolling and content accessibility
- Application form field layouts with responsive design for better mobile and desktop experience
- Application form data tabs with responsive positioning below title on small screens for improved usability
- Support ticket system with drawer-based interface replacing navigation-based approach for better performance and user experience

## Added
- **Ecosystem Market Priority System**: Ecosystem markets now automatically take precedence over spot markets when duplicate symbols exist (e.g., BTC/USDT ecosystem overrides spot)
- **Advanced Market Deduplication**: Intelligent market filtering that prioritizes ecosystem markets while maintaining clean, non-duplicate market lists
- **Enhanced Trading Markets Interface**: Markets panel now properly displays ecosystem markets with "Eco" badges and correct prioritization
- **Comprehensive Ecosystem Token Withdrawal Support**: Full withdrawal method generation for ecosystem tokens including:
  - Proper method titles with chain information (e.g., "BNB (BSC)")
  - Automatic address field generation for each blockchain network
  - Fee structure handling with fixed and percentage fee support
  - Processing time information and withdrawal instructions
  - Min/max amount limits with proper validation
- **Multi-Format Currency API Support**: Withdraw form now handles multiple API response formats:
  - Standard format: `{value: "USD", label: "USD - 109.01"}`
  - Ecosystem format: `{name: "BNB", chain: "BSC", icon: "/img/crypto/bnb.webp", type: "NATIVE"}`
  - Direct balance properties and label-based balance extraction
- **Advanced Withdrawal Method Interface**: Enhanced withdrawal method cards with:
  - Token/method icons with fallback to text abbreviations
  - Processing time badges (e.g., "1-3 days")
  - Fee information badges or "Free" indicators when no fees
  - Min/max amount displays with currency formatting
  - Blockchain network information for crypto withdrawals
- **Intelligent Fee Display System**: Dynamic fee badge rendering that:
  - Shows actual fees when present (e.g., "0.001 BNB + 0.5%")
  - Displays green "Free" badge when no fees apply
  - Hides empty fee badges to prevent UI clutter
- **Enhanced Market Service**: Improved market data handling with:
  - Ecosystem market inclusion in spot market API calls (`eco=true` parameter)
  - Automatic deduplication with ecosystem priority
  - Comprehensive logging for market loading and override tracking
  - Performance optimizations for large market datasets
- **Robust Error Handling**: Enhanced error management throughout withdraw flow:
  - Graceful handling of null/undefined currency entries
  - Proper validation for ecosystem tokens without balance info
  - Safe parsing of JSON fee and limit structures
  - Fallback mechanisms for missing or invalid data
- **User Experience Improvements**: Multiple UX enhancements including:
  - No auto-selection of withdrawal methods (user choice preserved)
  - Clear visual indicators for ecosystem vs spot markets
  - Proper loading states and error messages
  - Consistent styling across all withdrawal components
- **Futures Wallet Exclusion**: Removed futures wallets from withdrawal options since they only support transfers to ECO wallets, not direct withdrawals

## Removed
- Auto-selection behavior in withdrawal method selection
- Futures wallet type from withdrawal interface (transfer-only wallets)
- Duplicate useTranslations hook calls that violated React Rules of Hooks
- Empty fee badges that provided no useful information to users
- **KYC Application Drawer Enhancement**: Redesigned KYC application interface from separate page to drawer-based system:
  - 90% screen width drawer for maximum content visibility and better review experience
  - Responsive mobile layout with tab-based navigation (Details, Verify, User, Review tabs)
  - Desktop layout with side-by-side content and persistent review sidebar
  - Proper scrolling and content accessibility across all screen sizes
  - Mobile-optimized application form data tabs positioned below title for better usability
  - Responsive field layouts with proper badge positioning on small screens
  - Enhanced mobile experience with four-tab layout ensuring no content is omitted
  - Improved desktop workflow with larger content areas and efficient space utilization
- **Dark Mode UI Improvements**: Complete dark mode overhaul for KYC application interface including:
  - Softer button colors (blue-500/red-500 instead of harsh blue-600/red-600) with improved accessibility
  - Comprehensive zinc color palette implementation replacing gray/slate colors for design system consistency
  - Full dark mode support for verification status indicators (VERIFIED, FAILED, PENDING, MANUAL_REVIEW, APPROVED, REJECTED)
  - Dark theme variants for all verification progress bars and confidence score displays
  - AI analysis sections with proper dark backgrounds (indigo-950/20 opacity) for better readability
  - User profile header with dark mode gradient backgrounds and proper text contrast
  - Contact information cards with dark theme backgrounds and icon color adjustments
  - Account security cards with dark mode support for all status indicators and badges
  - Status badges with consistent dark mode patterns (950/20 backgrounds, 800/50 borders, 400 text colors)
  - Application form field containers with zinc-based dark backgrounds and borders
  - Image lightbox wrappers with dark mode support for document viewing
  - Section headers and metadata areas with proper dark theme styling
  - Empty state sections with dark mode backgrounds and improved contrast
  - Verification service badges and refresh buttons with dark theme variants
- **Support Ticket Drawer System**: Comprehensive drawer-based interface for support ticket management:
  - 90% screen width drawer for maximum content visibility and efficient ticket review
  - Responsive mobile and desktop layouts with optimized tab navigation (Chat, Customer, Timeline)
  - Real-time messaging interface with agent response capabilities and message history
  - Customer information panel with user details, avatar, and ticket statistics
  - Status update functionality with dropdown selection and instant ticket status changes
  - Mobile-optimized three-tab layout ensuring full functionality on small screens
  - Desktop side-by-side layout with persistent customer info and actions sidebar
  - Message composition with Enter-to-send functionality and attachment support
  - Proper error handling and loading states for all drawer operations
  - Seamless integration with existing DataTable "View Chat" buttons
  - Enhanced user experience eliminating navigation and 502 error issues 