# Core v5.2.9
**Release Date:** January 17, 2025  
**Tags:** FEATURE, BUG FIXES

## Fixed
- Admin support ticket page 502 errors on reload caused by authentication middleware redirect loops
- Permission mismatch between frontend and backend for support ticket access
- Token refresh error handling in authentication middleware
- Role cache initialization issues causing permission check failures
- Infinite redirect loops in admin route authentication flow
- Logo display mismatch in admin settings showing outdated database values instead of actual logo files
- Hydration mismatch errors in logo field components caused by Date.now() usage during SSR
- Settings page displaying incorrect logo types (icon vs text logos) due to file path confusion
- Logo upload failures in production mode caused by incorrect directory path resolution
- Dark logo upload errors in production environments due to path structure differences

## Enhanced
- Authentication middleware with better error handling and timeout management
- Token refresh mechanism with improved error recovery
- Role fetching system with proper cache validation
- Admin route permission checking with consistent error handling
- Support ticket page routing structure simplified from `/admin/crm/support/ticket/[id]` to `/admin/crm/support/[id]`
- Logo field component to display actual logo files instead of outdated settings values
- Logo preview system with proper hydration-safe rendering
- Logo upload path resolution with intelligent fallback mechanisms for production environments
- Directory creation logic with multiple path attempts and comprehensive error handling

## Added
- Specialized logo management system for admin system settings
- Direct logo file replacement in `/public/img/logo/` directory with proper filenames
- Automated multiple format generation (PNG and WebP) for all logo uploads
- Size-specific image processing with exact dimension requirements for each logo type
- Bulk logo update system that automatically updates related files (Apple touch icons, favicons, etc.)
- Modern drag-and-drop logo upload interface with live preview
- Logo file path mapping system that correctly associates logo types with their actual files:
  - Main Logo → `/img/logo/logo.webp` (square icon)
  - Full Logo → `/img/logo/logo-text.webp` (text logo)
  - Dark Logo → `/img/logo/logo-dark.webp` (dark theme icon)
  - Dark Full Logo → `/img/logo/logo-text-dark.webp` (dark theme text logo)
- Comprehensive logo mapping system supporting:
  - Main logos (logo, fullLogo, cardLogo)
  - Favicons (16x16, 32x32, 96x96)
  - Apple icons (57x57 through 180x180)
  - Android icons (192x192 through 512x512)
  - Microsoft icons (144x144)
- Logo upload validation with file type and size checking
- Automatic cache clearing after logo updates for immediate effect
- Settings database integration with proper logo URL updates
- Error handling and user feedback for logo upload operations
- Hydration-safe logo rendering with mounting state pattern to prevent SSR/client mismatches
- Production-ready path resolution utility for consistent file upload handling across environments
- Debug endpoint for troubleshooting path resolution issues in production deployments
- Enhanced logging system for logo upload operations with detailed path information 