# Core v5.2.8
**Release Date:** January 17, 2025  
**Tags:** FEATURE, BUG FIXES

## Fixed
- Builder page crashes when loading legacy page content format
- WebSocket connection stability issues in real-time features
- Admin Support Ticket page intermittent 502 errors due to hydration race conditions
- Ecosystem Token edit page hydration errors causing 502 responses
- Master wallet creation showing "undefined" chain options in dropdown
- Blockchain service availability errors (Solana, TRON, TON services showing as "not available")
- Chain status validation in blockchain services to properly detect enabled chains in both development and production environments
- Production deployment issues where blockchain services couldn't find their configuration files
- Master wallet chain options API returning "undefined" currency labels for dynamic blockchain chains
- Infinite image loading loops for missing cryptocurrency logos causing unlimited console errors
- Support ticket page 502 errors on refresh caused by browser-only API calls during server-side rendering
- Critical Next.js App Router 502 errors caused by missing page.tsx files in dynamic route parent folders:
  - Support ticket folder (admin/crm/support/ticket)
  - Finance wallet type folder (finance/wallet/[type])
  - Forex account folder (forex/account)
  - NFT collection folder (nft/collection)
  - NFT creator folder (nft/creator)
  - NFT token folder (nft/token)
  - NFT user folder (nft/user)
- P2P offer table sorting errors due to incorrect column field references
- Support ticket admin page SSR crashes caused by browser-only operations during server-side rendering
- Additional SSR protection for document API usage in export functions
- Backend TypeScript compilation errors preventing server startup (WebSocket handlers, Response types, Middleware fixes)

## Enhanced
- Finance deposit page currency selection with search and pagination
- Backend wallet address API to return proper address data instead of placeholder response
- Currency selection now supports filtering through 100+ currencies with search functionality
- Improved user experience with paginated currency lists (12 currencies per page)
- Admin page hydration stability with better error handling and race condition prevention
- Master wallet creation form with proper chain option loading and error handling
- Blockchain service initialization with robust file detection logic for both development (.ts) and production (.js) environments
- Cross-environment compatibility for blockchain service configuration detection

## Added
- Search functionality for currency selection in deposit forms
- Pagination controls for large currency lists
- Real-time search filtering with result counts
- Enhanced translation support for new UI elements
- Fallback images for missing cryptocurrency logos
- Improved error messages for blockchain service availability
- Production-ready blockchain service file detection with multiple path fallbacks
- Comprehensive logging for blockchain service initialization debugging 