# Core v5.2.5
**Release Date:** December 20, 2024  
**Tags:** 2FA SYSTEM, LOGO MANAGEMENT, EMAIL SYSTEM, BUG FIXES, LANGUAGE PERSISTENCE, DEFAULT LANGUAGE, SUPPORT TICKETS, ADMIN MENU

## Added
- New logo upload system for instant platform-wide logo updates
- Admin logo management interface at `/admin/system/logo`
- Automatic generation of all logo variants (favicons, app icons, etc.)
- Direct logo file updates without settings dependency
- Comprehensive two-factor authentication system validation
- Email verification resend functionality with proper error handling
- Environment variable validation for all 2FA methods (SMS, EMAIL, APP)
- Phone number requirement validation for SMS 2FA setup
- Enhanced OTP email template with professional styling and security warnings
- Cookie-based language persistence with 1-year expiration
- Automatic language detection with cookie priority over browser headers
- Proper locale prefix handling for consistent URL structure
- Enhanced language switching with immediate cookie storage
- Logo upload system for admin with automatic variant generation
- Professional OTP email templates with gradient design and security warnings
- Comprehensive 2FA environment variable validation
- Email verification resend endpoint with enhanced templates
- Enhanced error handling and user experience across 2FA flow
- NEXT_PUBLIC_DEFAULT_LANGUAGE environment variable support for configurable default locale
- Dynamic locale configuration throughout the application
- Comprehensive WebSocket functionality for support ticket real-time updates
- Proper JSON field parsing for support ticket messages and tags
- Admin menu extension visibility system showing all available extensions
- Disabled extension indicators in admin navigation menus
- Cache refresh functionality for extension status updates
- Comprehensive cache clearing system for browser, localStorage, and sessionStorage

## Fixed
- Email template placeholder replacement issues (SITE_NAME now displays correctly)
- Text alignment problems in email templates (lists now left-aligned)
- Missing email template variables and proper logo URL handling
- Incomplete order confirmation email details
- Logo display delays caused by settings dependency
- Two-factor authentication login endpoint mismatch (now uses correct `/api/auth/otp/login`)
- Email 2FA setup not sending actual OTP codes via email during verification
- SMS 2FA setup allowing configuration without phone number validation
- Inconsistent verification messages between APP, EMAIL, and SMS methods
- Missing environment variable validation for 2FA services
- Page builder "Cannot read properties of undefined (reading 'create')" error
- Email verification system with missing resend functionality
- 2FA system comprehensive issues across APP, EMAIL, and SMS methods
- Schema validation error with missing "EMAIL" enum value in 2FA endpoints
- OTP email template design and security messaging
- Recovery codes system verification and enhancement
- Language selection not persisting after page reload
- User language preference reverting to default language on page refresh
- Missing cookie-based language persistence causing poor user experience
- Language detection only using browser headers instead of saved preferences
- Hardcoded default locale not respecting NEXT_PUBLIC_DEFAULT_LANGUAGE environment variable
- Path utility functions using hardcoded locale prefixes instead of configured locales
- Support ticket WebSocket endpoint completely empty causing real-time updates to fail
- Critical bug in message posting endpoint using raw SQL queries instead of Sequelize
- Admin ticket detail endpoint with overly complex error handling causing failures
- User ticket detail endpoint missing proper JSON field parsing
- Admin ticket list endpoint missing JSON field parsing and error handling
- Support ticket schema definitions inconsistency between endpoints
- File upload in support tickets creating duplicate messages in UI
- Message parsing errors when tickets contain string-encoded JSON fields
- Missing error handling in support ticket API endpoints causing server crashes
- Admin menu not reflecting disabled extension status after cache updates
- Extension toggle not refreshing global settings cache causing menu inconsistencies
- Disabled extensions still appearing as clickable in admin navigation

## Enhanced
- Email template processing with proper variable replacement
- Order confirmation emails now include detailed breakdown
- Added product information, quantities, and pricing details
- Enhanced email content with shipping and tax information
- Better email template styling and structure
- Logo system now uses hardcoded paths for immediate updates
- Two-factor authentication user experience with method-specific instructions
- OTP email template with gradient styling and 5-minute expiration notice
- Recovery codes system with proper generation and consumption
- Email 2FA now sends actual OTP codes in addition to QR code generation
- Language middleware with proper next-intl integration
- Language selector component with immediate persistence
- Email template system with improved styling and messaging
- 2FA setup flow with better validation and error messages
- Logo management system with automatic file processing
- User experience for language switching and persistence
- Security messaging in authentication emails
- Error handling across authentication systems
- Default locale system to use environment variable configuration
- Path utility functions to use configured locales instead of hardcoded values
- Support ticket message handling with proper Sequelize model updates
- JSON field processing for messages and tags in all ticket endpoints
- Error handling patterns across all support ticket API endpoints
- WebSocket integration for real-time support ticket updates
- File upload functionality in support tickets with proper validation
- Admin menu filtering logic to show disabled extensions with visual indicators
- Extension management interface with cleaner layout and improved usability
- Cache refresh system with comprehensive browser storage clearing
- Extension toggle functionality with automatic settings cache refresh

## Technical Improvements
- Added missing models import in email utilities
- Enhanced order confirmation email function with complete order data
- Improved email template variable processing system
- Added LOGO_URL and SITE_NAME placeholder support
- Better error handling in email template processing
- Dynamic shipping cost integration in ecommerce order emails
- Logo upload endpoint with automatic variant generation
- Email templates now use direct logo links instead of settings
- Comprehensive logo management with WebP optimization
- Fixed page creation API endpoint model name casing (models.Page → models.page)
- Added comprehensive 2FA endpoint validation and error handling
- Improved email queue integration for OTP delivery
- Enhanced frontend 2FA setup flow with proper validation and user feedback
- Standardized error responses across all 2FA endpoints
- Implemented proper next-intl middleware configuration with cookie support
- Added NEXT_LOCALE cookie with 1-year persistence and secure settings
- Enhanced language detection algorithm with fallback priorities
- Improved locale prefix handling for consistent routing
- Centralized default locale configuration using NEXT_PUBLIC_DEFAULT_LANGUAGE
- Updated all hardcoded locale references to use environment variables
- Added comprehensive validation for 2FA environment variables
- Enhanced email template system with professional design standards
- Improved error handling patterns across authentication flows
- Replaced raw SQL queries with proper Sequelize model methods in support tickets
- Implemented comprehensive WebSocket functionality for support ticket real-time updates
- Added proper JSON field getters and setters in support ticket model
- Enhanced error handling with createError utility across all support endpoints
- Improved message parsing and validation in support ticket system
- Standardized API response formats across all support ticket endpoints
- Updated menu filtering logic to support disabled extension visibility in admin interface
- Enhanced mega menu components to handle disabled extensions with proper styling
- Implemented automatic cache refresh in extension toggle functionality
- Added debug logging for extension status tracking and menu generation
- Removed Actions column from extensions management table for cleaner interface
- Updated table column widths for better content distribution 