# Core v5.2.1 - Builder System Enhancements & Authentication Fixes
**Release Date:** June 27, 2025  
**Tags:** CRITICAL FIXES, MAJOR IMPROVEMENTS, UI IMPROVEMENTS, SYSTEM ENHANCEMENTS

## Fixed

### **CRITICAL FIXES** - Builder System
- **Margin Display Issue**: Fixed critical issue in builder where text elements showed "0 px without any width" in edit mode, making it impossible to see or modify margin values. Updated `getMarginHandleStyle` function to show margin areas when explicitly set (including 0 values).
- **NaN Value Errors**: Resolved NaN errors in margin/padding calculations that were breaking builder element editing. Added proper number conversion with `Number(rawValue) || 0` and `safeValue` checks in `MeasurementLabel` component.
- **Element Initialization**: Fixed builder element initialization failing to provide proper default settings for text elements, causing inconsistent spacing and layout issues.

### **CRITICAL FIXES** - Authentication System
- **Two-Factor Authentication Failure**: Fixed critical authentication system failure with error "APP_VERIFY_TOKEN_SECRET must be a 64 hex char string (32 bytes)" that was preventing 2FA login. Enhanced key generation logic to handle multiple secret formats (64 hex chars, 32 chars, longer/shorter strings).
- **Crypto Module Import**: Fixed crypto module import issue in OTP utilities that was causing authentication token generation failures.
- **Token Generation Robustness**: Added SHA256 hash fallback for invalid/empty authentication secrets with comprehensive try-catch error handling.


### **CRITICAL FIXES** - Translation System
- **Bad Keys Management**: Implemented automated bad translation key detection and fixing system
  - Added `translations:find-bad-keys` command to identify problematic keys
  - Created manual review process via bad-keys-report.json editing
  - Implemented `translations:fix-bad-keys` command for automated corrections
  - Fixed 3 critical bad keys: `back_to_offer`, `%_complete`, `loading_page_content`

### **CRITICAL FIXES** - Trading Interface Market Switching
- **Market Data Contamination**: Fixed critical issue where switching markets in /trade interface caused old market data to persist and contaminate new market display
  - **Chart Data Cleanup**: Previous market's candle data no longer shows on new market charts
  - **Price Data Reset**: Old market prices no longer display on new market panels
  - **WebSocket Subscription Management**: Proper cleanup of old market subscriptions prevents data leaks
  - **Component State Isolation**: Each market gets completely fresh component state

### **CRITICAL FIXES** - TradingView Chart Integration
- **WebSocket Unsubscribe Issue**: Fixed TradingView chart not sending unsubscribe messages when changing markets
  - **Subscription Cleanup**: Proper unsubscription from old market data streams
  - **Live Data Flow**: Restored live candle updates after market switches
  - **Memory Leak Prevention**: Eliminated orphaned WebSocket subscriptions

### **CRITICAL FIXES** - Mobile Trading Interface
- **Market Switching**: Enhanced mobile market switching to use proper cleanup system
  - **Chart Remounting**: Improved chart component remounting on mobile devices
  - **State Synchronization**: Better state management for mobile trading interface
  - **Performance Optimization**: Reduced unnecessary re-renders on mobile

## Enhanced

### **UI IMPROVEMENTS** - Builder Interface
- **Margin/Padding Visibility**: Enhanced margin/padding visibility logic in builder resizable component to only hide hover areas when values are `undefined` or `null`, not when they're `0`. This provides better visual feedback for element spacing.
- **Element Templates**: Updated text element templates with appropriate default spacing: paragraphs (16px), headings (24px), quotes (20px), links (12px), lists (16px) for consistent typography hierarchy.
- **Visual Feedback**: Improved builder margin/padding display logic to provide clearer visual indicators when editing element spacing properties.

### **SYSTEM ENHANCEMENTS** - Authentication
- **Key Format Handling**: Strengthened authentication system to gracefully handle multiple secret key formats with automatic conversion and validation.
- **Error Recovery**: Enhanced authentication token generation with graceful error handling and fallback mechanisms to prevent system failures.
- **Security Robustness**: Maintained 32-byte key requirement for AES-256-GCM encryption while adding flexibility for different input formats.

### **UI IMPROVEMENTS** - Navigation Menu Organization
- **Menu Restructuring**: Moved P2P from standalone menu item to "P2P Trading" under Trade category
  - **Logical Grouping**: All trading-related features now organized in one category
  - **Improved UX**: Better navigation structure for trading functionalities
  - **Consistent Design**: Maintains same functionality with improved organization

### **SYSTEM ENHANCEMENTS** - Trading Interface Performance
- **Market Switching Architecture**: Implemented comprehensive event-driven cleanup system
  - **Centralized Coordination**: Trading layout orchestrates cleanup across all components
  - **Component Isolation**: Each component handles its own cleanup when notified
  - **Memory Efficiency**: Prevents subscription leaks and memory bloat
  - **Performance Optimization**: Faster market switching with proper cleanup

### **SYSTEM ENHANCEMENTS** - Code Quality
- **Log Cleanup**: Removed unnecessary console logging from trade components
  - **Reduced Console Noise**: Cleaner development and production environments
  - **Performance Improvement**: Less console output improves performance
  - **Maintained Debugging**: Preserved error and warning logs for troubleshooting



## Added

### **MAJOR FEATURES** - Builder Template System
- **Complete Template Overhaul**: Added 22 new modern, professional section templates organized across 10 categories, replacing all outdated templates with contemporary designs.

### **NEW FEATURES** - Hero Sections
- **Trading Hero**: Advanced trading platform hero with animations, gradient backgrounds, and modern call-to-action elements.
- **Crypto Hero**: Full-width cryptocurrency-focused hero section with dark theme and professional typography.
- **Investment Hero**: Professional investment-focused layout with clean design and trust-building elements.
- **Modern Hero**: Minimalist hero design with clean typography and contemporary styling.

### **NEW FEATURES** - Feature Sections  
- **Trading Features**: Comprehensive trading platform feature showcase with icons and detailed descriptions.
- **Security Features**: Security-focused feature section highlighting platform safety measures and protections.
- **Platform Features**: General platform capabilities section with modern card-based layout.

### **NEW FEATURES** - Statistics Sections
- **Trading Stats**: Real-time trading statistics display with animated counters and professional metrics.
- **Performance Stats**: Platform performance metrics with visual indicators and growth statistics.
- **Global Stats**: Worldwide platform statistics with geographic and demographic data visualization.

### **NEW FEATURES** - Additional Sections
- **Client Testimonials**: Professional client testimonial section with ratings and user photos.
- **Trader Testimonials**: Trading-specific testimonials with success stories and performance highlights.
- **Premium Plans**: Subscription-based pricing plans with feature comparison and upgrade paths.
- **Trading Plans**: Trading-specific pricing tiers with commission structures and benefits.
- **Company Story**: About section focusing on company history and mission.
- **Team Overview**: Team member showcase with professional profiles and expertise areas.
- **Contact Form**: Modern contact form with validation and professional styling.
- **Support Center**: Support-focused contact section with multiple communication channels.
- **Join Platform**: Call-to-action section encouraging platform registration and onboarding.
- **Start Trading**: Trading-focused CTA section with immediate action prompts.
- **Latest Updates**: News section for platform updates and announcements.
- **Market News**: Financial market news and analysis section.
- **Learning Resources**: Educational content section with courses and tutorials.
- **Trading Guides**: Trading-specific educational content with step-by-step guides.



### **SYSTEM ENHANCEMENTS** - Template Architecture
- **Modern Design Features**: All new templates include animations, dark/light mode support, and responsive layouts for optimal user experience across devices.
- **Professional Styling**: Implemented professional color schemes and typography standards across all new templates for brand consistency.
- **TypeScript Integration**: Added proper TypeScript interfaces and metadata for all new templates ensuring type safety and better development experience.
- **Responsive Design**: All templates built with mobile-first approach and comprehensive responsive breakpoints.

## Removed

### **SYSTEM CLEANUP** - Template System
- **Legacy Templates**: Removed all old broken section templates and their directories that were causing import errors and build issues.
- **Broken Imports**: Cleaned up template index file removing all broken imports and registrations that were preventing proper template loading.
- **Outdated Components**: Removed deprecated template components that were no longer compatible with current system architecture.

### **Technical Details**

### **Files Modified**
- `frontend/app/[locale]/(dashboard)/admin/builder/components/canvas/resizable.tsx` - Enhanced margin/padding display logic
- `frontend/app/[locale]/(dashboard)/admin/builder/templates/elements/index.tsx` - Updated element defaults
- `frontend/app/[locale]/(dashboard)/admin/builder/templates/sections/index.ts` - Complete rewrite with new templates
- `backend/src/api/auth/otp/utils.ts` - Authentication system fixes
- `frontend/messages/bad-keys-report.json` - Bad keys fixes applied
- `frontend/app/[locale]/trade/components/trading-layout.tsx` - Market switching cleanup system
- `frontend/components/blocks/advanced-chart/context/chart-data.ts` - Chart data cleanup and cache management
- `frontend/app/[locale]/trade/components/chart/chart-panel.tsx` - Chart component remounting logic
- `frontend/app/[locale]/trade/components/markets/markets-panel.tsx` - Markets panel cleanup system
- `frontend/app/[locale]/trade/components/orderbook/orderbook-panel.tsx` - Orderbook data cleanup
- `frontend/components/blocks/tradingview-chart/index.tsx` - TradingView subscription management
- `frontend/app/[locale]/trade/components/layout/mobile-layout.tsx` - Mobile market switching
- `frontend/config/menu.ts` - Menu reorganization (P2P moved to Trade category)
- 22 new section template files created across 10 categories

### **Builder System Improvements**
- Enhanced `getMarginHandleStyle` and `getPaddingHandleStyle` functions for better visual feedback
- Improved element initialization with type-specific defaults in `Element` component
- Updated `MeasurementLabel` component with robust number conversion and validation
- Added comprehensive margin/padding value handling for both defined and undefined states

### **Authentication System Enhancements**
- Enhanced `generateKey` function to handle multiple secret formats with graceful fallbacks
- Added comprehensive error handling with try-catch blocks and meaningful error messages
- Implemented SHA256 hash fallback for invalid/empty secrets maintaining security standards
- Fixed crypto module import pattern for better compatibility

### **Trading System Improvements**
- **Market Switching Flow**: Comprehensive 5-step cleanup process for clean market transitions
  - Step 1: Cleanup old WebSocket subscriptions (ticker, orderbook, OHLCV for all timeframes)
  - Step 2: Clear chart data cache via custom events
  - Step 3: Reset state variables and current price
  - Step 4: Update URL with new market info
  - Step 5: Force component remounts and chart resize
- **Data Flow Protection**: Symbol validation ensures data belongs to current market before processing
- **Race Condition Prevention**: Proper cleanup ordering prevents data mixing between markets
- **Component Coordination**: Event-driven architecture ensures all components cleanup simultaneously

### **Template System Architecture**
- Modern template structure with proper metadata and thumbnail configurations
- Consistent naming conventions and organization across all template categories
- Backward compatibility functions maintained for existing template references
- Professional design patterns implemented across all new templates

### **TradingView Chart Market Switching** - `WEBSOCKET IMPROVEMENTS`
Fixed critical issue where TradingView charts were not properly unsubscribing from previous market WebSocket streams when switching markets. The chart now correctly sends unsubscribe messages and prevents data contamination between different trading pairs.

### **TypeScript Build Errors** - `SYSTEM ENHANCEMENTS`
Resolved all TypeScript compilation errors across frontend and backend:
- Fixed missing binary store functions and market interfaces
- Corrected orderbook panel type definitions  
- Enhanced futures trading type safety with proper leverage handling
- Resolved menu type conflicts and system settings validation
- Fixed language drawer and notification timeline type issues

### **P2P Offer Validation** - `TRADING INTERFACE`
Enhanced P2P offer creation with mandatory field validation:
- **Location**: Country selection is now required with visual indicators
- **Payment Methods**: At least one payment method must be selected
- **Trade Terms**: Terms of trade are now mandatory for all offers
- Added validation alerts and red border styling for incomplete fields
- Enhanced backend validation with proper error messages

### **KYC File Upload System** - `NEW FEATURES`
Implemented comprehensive KYC document upload functionality:
- Added FILE field support to dynamic KYC forms alongside existing IMAGE fields
- Created dedicated KYC document upload endpoint supporting multiple file types
- Enhanced file validation with 50MB limit for documents vs 10MB for images
- Supports images (JPEG, PNG, WebP, GIF) and documents (PDF, DOC, DOCX, XLS, XLSX, TXT, CSV)
- Removed archive file support (ZIP, RAR, 7Z) for security reasons
- Added drag & drop upload interface with file preview and management

### **Deposit Method Custom Fields** - `ADMIN IMPROVEMENTS`
Fixed validation error preventing use of FILE and IMAGE field types in deposit method custom fields. Backend validation schemas now properly support all four field types: input, textarea, file, and image.

### **Translation Management** - `SYSTEM ENHANCEMENTS`
Fixed 627 invalid translation keys that contained periods or special characters. Updated translation system to properly handle namespaced keys and synchronized new validation messages across all 57 supported locales.

### **Market Switching Coordination** - `TRADING INTERFACE`
Improved market switching reliability across all trading interfaces:
- Enhanced 5-step cleanup process for WebSocket subscriptions
- Better coordination between chart components and market data
- Prevented data contamination between different trading pairs
- Added proper component remounting with dynamic keys

### **Form Validation UX** - `UI IMPROVEMENTS`
Enhanced user experience for form validation across P2P and KYC systems:
- Added visual indicators (red asterisks) for required fields
- Implemented red border styling for incomplete fields
- Added clear validation alerts explaining requirements
- Improved step completion logic with proper validation checks

---

*These enhancements significantly improve the builder system usability and fix critical authentication issues. The new template system provides modern, professional options for creating impressive websites while maintaining system stability and security.* 