# Core v5.2.0 - Authentication & KYC Fixes
**Release Date:** June 27, 2025  
**Tags:** CRITICAL FIXES, MAJOR IMPROVEMENTS, SYSTEM ENHANCEMENTS

## Fixed

### **CRITICAL FIXES** - Authentication System
- **2FA Login Flow**: Fixed missing 2FA OTP verification step during login process. The login form now properly displays the OTP input when 2FA is enabled, preventing users from being stuck without authentication options.
- **Login Response Handling**: Enhanced login store and form to properly handle 2FA responses from backend authentication endpoints.

### **CRITICAL FIXES** - KYC System  
- **KYC Status Recognition**: Fixed KYC completion status not being properly recognized across the application. Updated utility functions to correctly check user KYC approval status.
- **Feature Access Control**: Enhanced KYC feature access checking to properly validate user permissions based on approved KYC applications.
- **KYC Application Page**: Fixed 502 server errors on KYC application pages by correcting API import statements and request handling.

### **MAJOR IMPROVEMENTS** - User Experience
- **KYC Utility Functions**: Improved KYC utility functions with better error handling and support for multiple KYC applications per user.
- **Authentication Flow**: Enhanced login form to seamlessly transition between password entry and 2FA verification without page reloads.
- **Error Handling**: Added comprehensive error handling for authentication and KYC-related API calls.
- **Referral System**: Enhanced registration form to display referrer information when users sign up via referral links, showing a read-only field with the referring user's code.

## Enhanced

### **UI IMPROVEMENTS** - Authentication
- **2FA Integration**: Improved 2FA form integration within the login modal for better user experience.
- **Loading States**: Enhanced loading states during authentication and KYC verification processes.
- **Referrer Display**: Added visual indication of referrer in registration form with proper styling and user-friendly messaging.

### **SYSTEM ENHANCEMENTS** - KYC Management
- **Status Validation**: Enhanced KYC status validation logic to handle edge cases and multiple application scenarios.
- **Feature Access**: Improved feature access validation to work correctly with approved KYC levels and features.
- **API Integration**: Strengthened API integration for KYC application retrieval and status checking.

### **SYSTEM ENHANCEMENTS** - Chart & Trading System
- **Empty Chart State Display**: Added proper empty state overlay when no chart data is available, showing user-friendly message instead of blank chart area.
- **TradingView Chart Error Prevention**: Fixed JavaScript errors in TradingView chart component when receiving empty or invalid OHLCV data from WebSocket streams. Added comprehensive validation for all data structures passed to TradingView library.
- **TradingView Data Validation**: Enhanced TradingView chart data processing with robust validation for API responses, WebSocket messages, and individual candle data to prevent crashes when markets have no trading data.
- **TradingView Symbol Formatting**: Improved symbol formatting for TradingView charts to use proper base/quote extraction logic instead of hardcoded currency lists, ensuring compatibility with all trading pairs.
- **TradingView API Integration Fix**: Fixed TradingView chart data fetching by switching from native fetch to $fetch to match v4 working pattern. Resolved "Not Found" JSON parsing errors that were causing chart initialization failures.
- **TradingView Data Processing**: Simplified TradingView data processing to match proven v4 implementation, removing over-validation that was causing compatibility issues with the TradingView library.
- **TradingView Callback Protection**: Added comprehensive error handling for all TradingView library callbacks (onReady, resolveSymbol, getBars, onRealtimeCallback, onChartReady) to prevent library errors from propagating to the application.
- **TradingView Error Handling**: Enhanced TradingView chart error handling to return empty data instead of throwing errors when API calls fail, preventing chart initialization failures.
- **API Error Response Handling**: Improved API error handling to gracefully process 404 "Not Found" responses without JSON parsing errors, ensuring chart components remain functional even when data is unavailable.
- **Symbol Format Validation**: Removed unnecessary symbol format validation warnings that were causing console spam, as symbol formatting is properly handled by the API formatting functions.
- **Orderbook Subscription Fix**: Fixed orderbook WebSocket subscription/unsubscription loop by stabilizing callback dependencies and removing unnecessary resubscriptions on aggregation level changes.
- **Empty Orderbook State**: Added proper empty state display for orderbook when no bids or asks are available, showing user-friendly message instead of loading spinner.
- **Chart Animation Infinite Loop Fix**: Fixed critical infinite loop in chart animation system by stabilizing useEffect dependencies, preventing constant re-rendering and improving chart performance significantly.

## Added



### **Translation Management System**
- **Enhanced Error Reporting**: Fixed translation manager to provide clear explanations when it cannot automatically fix certain translation keys
- **Bad Key Detection**: Improved detection and handling of translation keys where key equals value (e.g., "order_failed" = "order_failed")
- **Manual Review Process**: Added comprehensive guidance for fixing keys that require human input to determine proper display text
- **Safety Measures**: Translation system now prevents automatic fixes that could result in incorrect assumptions about intended meaning



### **Translation System Workflow**
- **Better Feedback**: Translation manager now explains why certain keys require manual review instead of automatic fixing
- **Improved Guidance**: Added examples and step-by-step instructions for resolving translation key issues
- **Detection Logic**: Enhanced bad key detection to identify keys that need proper human-readable values
- **User Education**: Added explanatory messages about translation system design decisions and safety measures



### **Technical Details**

### **Translation Management**
- `findBadlyCreatedKeys()` function now provides comprehensive reporting and guidance
- `fixInvalidKeys()` function includes detection of keys requiring manual review
- Enhanced error messages explain the difference between automatic fixes and manual review requirements
- Added safety checks to prevent incorrect assumptions about translation key meanings



### **Chart System Performance**
- **Infinite Error Loop Fix**: Resolved issue where chart animation would log thousands of "Skipping chart render due to invalid data or dimensions" errors
- **Smart Warning Throttling**: Implemented intelligent warning throttling system that limits console spam to once per 5 seconds per unique error condition
- **Animation Loop Optimization**: Enhanced animation loop to properly exit when data is invalid instead of continuously retrying
- **Memory Leak Prevention**: Added automatic cleanup of old warning entries to prevent memory accumulation
- **Better Data Validation**: Improved early exit conditions to prevent unnecessary animation frame requests with invalid data
- **Performance Monitoring**: Added detailed error context including data length, dimensions, and market switching state for better debugging
- **Variable Initialization Fix**: Fixed "Cannot access 'shouldRenderChart' before initialization" error by properly ordering variable declarations



---

*These fixes resolve critical authentication and KYC issues that were preventing users from accessing platform features after completing verification requirements. Enhanced translation management system provides better error handling and guidance for translation key maintenance.* 