# Version 5.0.8
**Release Date:** June 20, 2025  
**Tags:** CRITICAL FIXES, DOCUMENTATION

## Fixed

### Swagger Documentation System
- **TypeScript Import Error**: Fixed "Missing initializer in const declaration" errors when generating docs
- **Production File Handling**: Updated `getApiSourcePath()` function to prioritize compiled JavaScript files over TypeScript files
- **File Path Resolution**: Production now uses compiled files from `backend/dist/src/api` instead of raw TypeScript files
- **Fallback System**: Added fallback to compiled files in development as well for consistency

### Admin Settings System
- **UI Value Display**: Fixed settings page showing default/disabled values after saving instead of actual saved values
- **Data Refresh**: Modified settings page to refetch settings from server after saving to ensure UI reflects database state
- **State Management**: Previously only updated local state after save, now calls `fetchSettings()` to get real saved values from backend

### Settings Validation System
- **Empty Value Validation**: Fixed "validation error: value: value can not be empty" when saving settings with empty database
- **Validation Conflict**: Removed conflicting `notEmpty` validation from settings model that rejected empty strings
- **Null Handling**: Fixed conflict where model had `allowNull: true` but also `notEmpty` validation
- **API Compatibility**: API layer converts null values to empty strings, now properly handled by validation

### API Documentation Endpoint
- **Production Access**: Fixed `/api/docs` not working in production environment
- **Multi-path Fallback**: Updated docs system with multi-path fallback approach for different deployment scenarios
- **Directory Handling**: Fixed directory read error when accessing `/api/docs/` with empty file path
- **Swagger Generation**: Fixed swagger.json generation path and automatic directory creation
- **Error Handling**: Enhanced error logging and debugging information for missing environment variables

## Enhanced

### Documentation Infrastructure
- **Path Management**: Added `getDocsUIFolderPath()` and `getSwaggerDocPath()` functions for better path handling
- **Error Diagnostics**: Improved error handling and debugging information for documentation generation
- **Environment Flexibility**: Better handling of different deployment environments and configurations 